StorySelector = copy_table(BaseView)
StorySelector.definition = "story_selector"

StorySelector.book_def = {
    book = {
        type = "Button",
        bitmap = "gfx/story_selector/book_base",
        bitmap_hi = "gfx/story_selector/book_base_hi",
        mouse_click = "story_button",
        extra = 1,
        x=100, y=100, z=10,
        click_sound = "menu_big_button",
        angle = 10,
    },

    detail = {
        type = "Bitmap",
        bitmap = "gfx/story_selector/book_detail1",
        x=100, y=100, z=11,
        angle = 10,
    },

    bookmark = {
        type = "Bitmap",
        bitmap = "gfx/story_selector/book_bookmark",
        x=100, y=100, z=12,
        angle = 10,
    },
}


function StorySelector:init(options)
    BaseView.init(self)
    if options and options.won_game then
        self.won_game = true
    end

    local unlocked = self:load()
    self:add_book(150, 281, -30, 1, unlocked[1])
    self:add_book(275, 170, -54, 2, unlocked[2])
    self:add_book(522, 170, -25, 3, unlocked[3])
    self:add_book(636, 285, 52, 4, unlocked[4])
    self:add_book(518, 395, -5, 5, unlocked[5])
    self:add_book(273, 392, 10, 6, unlocked[6])
    self:add_book(395, 281, 37, 7, unlocked[7])
    
    for i = 1, 7 do
        if unlocked[i] or self.won_game then
            self.shortcuts.no_stories.enabled = false
            break
        end
    end

    snd_play_music("music/hearts.ogg")
end


function StorySelector:add_book(x, y, angle, number, unlocked)
    if unlocked or self.won_game then
        self.book_def.book.x = x
        self.book_def.book.y = y
        self.book_def.book.angle = angle
        self.book_def.book.extra = number
        self:create_and_add_object(self.book_def.book)

        self.book_def.detail.x = x
        self.book_def.detail.y = y
        self.book_def.detail.angle = angle
        self.book_def.detail.bitmap = "gfx/story_selector/book_detail"..number
        self:create_and_add_object(self.book_def.detail)

        if unlocked then
            self.book_def.bookmark.x = x
            self.book_def.bookmark.y = y
            self.book_def.bookmark.angle = angle
            --self.book_def.bookmark.disabled = true
            self:create_and_add_object(self.book_def.bookmark)
        end
    end
end


function StorySelector:story_button(obj)
    self:unlock(obj.extra)
    snd_play_sound("button_click")
    fw:change_view(Story, { story_name = "story"..obj.extra } )
end


function StorySelector:exit_button(obj)
    fw:change_view(MainMenu)
end


function StorySelector:unlock(id)
    local data = ""
    local count = 0
    
    unlocked = self:load()
    unlocked[id] = true
    
    for i = 1, 7 do
        if unlocked[i] then
            data = data.."["..i.."] = true,\n"
        else
            data = data.."["..i.."] = false,\n"
        end
    end

    file_save("profiles/stories.sav", data)
end


function StorySelector:load()
    local data = {}

    if file_exists("profiles/stories.sav") then
        data = file_load_lua_table("profiles/stories.sav")
    end
    
    return data
end
